#ifndef GPIO_CONTROL_H__
#define GPIO_CONTROL_H__

#include "pthrpoll.h"

typedef struct {
    int device_id;              // 设备ID (101, 102等)备名称
    int category_id;
    void (*device_pwm_value)(int pin,int val);    // PWM初始化函数指针
    void (*device_pin_value)(int pin,int value);// 速度控制函数指针
    void (*device_gpio_pthread_create)(void);
} gpiocontrol_t;

// 坦克射击状态枚举
typedef enum {
    TANK_STATE_READY,     // 可射击
    TANK_STATE_SHOOTING,  // 射击中
    TANK_STATE_COOLDOWN   // 冷却中
} TankState;

// 坦克射击控制结构体
typedef struct {
    uint64_t last_shot_end_time;   // 上次射击结束时间
    uint64_t shooting_start_time;  // 本次射击开始时间
    TankState state;               // 当前状态
    uint32_t shot_interval_ms;     // 射击冷却间隔（毫秒）
    uint32_t shot_duration_ms;     // 单次射击持续时间（毫秒）
} TankFireControl;

void device_gpio_control(int device_id,int pin,int val);

int device_shot_cooling_init();

extern ThreadPool_t *g_pool_device_gpio_control_t;

void set_gpio_control_config_t(ThreadPool_t *s);

extern int g_tank_shot_index;

void device_fast_read();//快速判断
 
#endif