#include "main.h"

int main(){
   if(mylog_init()!=0){
       my_zlog_error("日志初始化失败，错误代码：%d",mylog_init());
       return -1;
   }

   if(wiringPiSetup() == -1) {
        my_zlog_fatal("WiringPi setup failed!");
        return -2;
   }

   if(device_id_file_init()!=0){
       my_zlog_error("设备id读取失败");
       return -3;
    }
    if(device_mqtt_topic_init()!=0){
      my_zlog_error("设备id判断失败");
       return -4;
    }

   if(request_date() !=0){
    my_zlog_error("请求数据失败");
       return -5;
    }

   if(http_mqtt_video_init() !=0){
      my_zlog_error("请求mqtt服务器和video数据失败");
      return -6;
   }

   if(softiic_init()!=0){
      my_zlog_error("软件iic初始化失败");
       return -7;
    }

   if(ina225_init()!=0){
      my_zlog_warn("此版本电压没有使用INA226");
   }

   if(device_shot_cooling_init()!=0){
      my_zlog_warn("该设备没有冷却");
   }

   if(audio_config_init()!=0){
      my_zlog_warn("音频配置初始化失败");
   }
   
   if (audio_init()==0){
      my_zlog_info("音频命令执行初始化成功");
   }

   int thread_rc=thread_start_init( thread_exit_time,thread_mqtt_beat,
         thread_open_browser,thread_mqtt_reconnect,thread_time_calculation,thread_play_mp3);
   if(thread_rc != 0){
      my_zlog_warn("多线程初始化失败");
      return -7;
   } 

   thread_end_close();
   device_end_close(g_device_type);
   self_control_thread_close();//销毁自控的线程
   my_log_close();//关闭日志
   my_zlog_info("程序关闭成功");
   return 0;

}