#include "common.h"
#include "warn.h"
#include "http_request.h"
#include "gpio_control.h"
#include "device_init.h"
#include "devcontrol_common.h"

//最高警报，最低电压报警
int alarm_highest(int index) {
    if(index == 1) {
        device_gpio_control(g_device_type,20,1);//紫灯
        if(g_enable_buzzer_value) {
        device_gpio_control(g_device_type,22,1);//蜂鸣器
        }
    }else if(index == 0) {
        device_gpio_control(g_device_type,20,0);//紫灯
        device_gpio_control(g_device_type,22,0);//蜂鸣器
    }

    return index ;
}

//比较小警报
int alarm_low(int index) {
    if(index == 1) {
        device_gpio_control(g_device_type,16,1);//黄灯
    } else if(index == 0) {
        device_gpio_control(g_device_type,16,0);//黄灯
    } 

    return index ;
}

int alarm_control_open(float voltage) {//关闭警报

    if( voltage >= g_warn_voltage_value ) {
        alarm_highest(0);
        alarm_low(0);
    }else if(voltage >= g_err_voltage_value&&voltage <= g_warn_voltage_value) {
        alarm_low(1);
        alarm_highest(0);
        my_zlog_warn("电压警告");
    }else if(voltage < g_err_voltage_value) {
        alarm_highest(1);
        alarm_low(1);
        my_zlog_warn("换电警告");
    }   
    
    return 0; 
}

int alarm_control_close(float voltage) {//关闭警报

    my_zlog_debug("未开启警报，读取电压：%.2f",voltage);

    return 0; 
}

int alarm_control(float voltage) {
    #if WARN_MODE == 1
        my_zlog_info("Mode 1: 执行代码A");
        return alarm_control_open(voltage);
    #elif WARN_MODE == 2
        my_zlog_info("Mode 2: 执行代码B");
        return alarm_control_close(voltage);
    #else
        my_zlog_error("未知的 WARN_MODE: %d", WARN_MODE);
        return -1;
    #endif
}