#ifndef PTZ_COMMON_H
#define PTZ_COMMON_H

#include "ptz0401_control.h"
#include "ptz0404_control.h"

/* ===================== 硬件/PWM 参数 ===================== */
#define PWM_PIN_up        21
#define PWM_PIN_down      2

#define SERVO_FREQ        50.0f
#define PWM_RANGE         1024

// 舵机脉冲宽度（ms）- 适配 270 度舵机
#define MIN_PULSE_WIDTH   0.5f
#define MAX_PULSE_WIDTH   2.5f

/* ===================== 轴结构体与全局变量 ===================== */
typedef struct {
    // --- 实时状态 ---
    float angle;        // 当前角度
    float target;       // 目标角度
    float speed;        // 当前实时速度

    // --- 静态配置 (每个轴独立) ---
    float min_limit;    // 最小角度限位
    float max_limit;    // 最大角度限位
    float max_speed_cfg;// 最大速度配置 (°/s)
    float accel_cfg;    // 加速度配置 (°/s²)
} ServoAxis;

void device_ptz_pwm_task_threadpoll_init();

#endif