#include "common.h"
#include "gpio_init.h"
#include "http_request.h"
#include "device_init.h"
#include "devcontrol_common.h"


#define MIN_DUTY 0  // 最小占空比
#define MAX_DUTY 100 // 最大占空比

int g_gpioPwm[20];//软件控制pwm引脚
int g_gpiowpi[30]; //能使用高低引脚和其他引脚
int g_gpio_input[20]; //能读取引脚

int g_gpiocount=0; //gpio引脚数量
int g_gpio_softpwmcount=0;//pwm引脚数量
int g_gpio_inputcount=0;

/*初始化gpio*/
void init_gpiowpi(const int *values_pin) {
    while (values_pin[g_gpiocount] != -1) {
        g_gpiocount++;
    }
    for (int i = 0; i < g_gpiocount; i++) {
        g_gpiowpi[i] = values_pin[i];
    }     
    // 设置所有GPIO为输出模式
    for(int i = 0; i < g_gpiocount; i++) {
        pinMode(g_gpiowpi[i], OUTPUT);
        digitalWrite(g_gpiowpi[i], LOW);  // 初始化所有引脚为低电平
    } 
}

/*初始化gpio pwm*/
void init_gpiopwm(const int *values_pwm) {
    while (values_pwm[g_gpio_softpwmcount] != -1) {
        g_gpio_softpwmcount++;
    }
    for (int i = 0; i < g_gpio_softpwmcount ; i++) {
        g_gpioPwm[i] = values_pwm[i];
    } 
    for(int i = 0; i < g_gpio_softpwmcount; i++) {
        softPwmCreate(g_gpioPwm[i], MIN_DUTY, MAX_DUTY);
    } 
}

/*初始化gpio 输入模式*/
void init_gpio_input(const int *values_pwm) {
    while(values_pwm[g_gpio_inputcount] != -1){
        g_gpio_inputcount++;
    }
    //g_gpio_inputcount=sizeof(values_pwm) / sizeof(values_pwm[0]);
    for (int i = 0; i < g_gpio_inputcount ; i++) {
        g_gpio_input[i] = values_pwm[i];
    } 
    for(int i = 0; i < g_gpio_inputcount; i++) {
        pinMode(g_gpio_input[i], INPUT);
        pullUpDnControl(g_gpio_input[i], PUD_UP);
    } 
}

void pin_all_default() {//全部至低电平,车和坦克共用
	for (int i=0;i<g_gpiocount;i++) {
        if(g_gpiowpi[i]==16 || g_gpiowpi[i]==20 || g_gpiowpi[i]==22) continue;
		digitalWrite(g_gpiowpi[i], LOW);
	}
}

void tank0204_pin_all_default() {//全部至低电平,坦克0204专用
	for (int i=0;i<g_gpiocount;i++) {
        if(g_gpiowpi[i]==16 || g_gpiowpi[i]==6) continue;
		digitalWrite(g_gpiowpi[i], LOW);
	}
}

void pwm_all_default() {//全部至低电平,车和坦克共用
	for (int i=0;i<g_gpio_softpwmcount;i++) {
		softPwmWrite(g_gpioPwm[i], 0);
	}
}

void tankpwm_default() {//全部至低电平,车和坦克共用

	for (int i=0;i<g_gpio_softpwmcount;i++) {
		if(g_gpioPwm[i]!=27) softPwmWrite(g_gpioPwm[i], 0);

	}

}


/*物理pwm初始化*/
void physics_pwm_init() {
    int pwm_clock = 24000000 / (50 * 1000);// 定义 PWM 频率为 50Hz
    pinMode(PWM_PIN_SPEED,PWM_OUTPUT);
    pinMode(PWM_PIN_CHANGE,PWM_OUTPUT);
    pwmSetClock(PWM_PIN_SPEED,pwm_clock);//=19200*1000/(hz*2000)
    pwmSetRange(PWM_PIN_SPEED,1000);//占空比范围
    pwmSetClock(PWM_PIN_CHANGE,pwm_clock);//=19200*1000/(hz*2000)
    pwmSetRange(PWM_PIN_CHANGE,1000);//占空比范围
    
}

