#include "common.h"
#include "temperature.h"
#include "mylog.h"

#define MAX_LINE_LENGTH 20

char g_temperature[20];

/*温度获取*/
int heat_tem() {
    FILE *file;
    float temp_str;
    char line[MAX_LINE_LENGTH];
    file = fopen("/sys/class/thermal/thermal_zone0/temp", "r");
    if (file == NULL) {
        perror("无法打开温度文件");
        return 1;
    }

    if (fgets(line, sizeof(line), file) != NULL) {
        temp_str = (float)atof(line) / 1000.0;
        sprintf(g_temperature, "%.2f°C", temp_str);
        my_zlog_debug("CPU 温度: %.2f°C", temp_str);
    }else {
        temp_str =0;
        sprintf(g_temperature, "%.2f°C", temp_str);
        my_zlog_debug("CPU 温度: %.2f°C", temp_str);
    }
    fclose(file);
    return 0;
}    