#ifndef PG0403_SERIAL_H
#define PG0403_SERIAL_H

#include "devcontrol_common.h"
#define MAX_TAGS 30  // 假设最大标签数量

// 卡尔曼参数配置 (根据实际效果调整)
// R (测量噪声): 值越大，滤波越平滑，但滞后越明显。防止漂移建议设大一点 (10 ~ 100)
// Q (过程噪声): 值越大，系统认为物体运动越快。如果对运动响应太慢，把这个调大 (0.01 ~ 1.0)
#define KALMAN_R 50.0f  
#define KALMAN_Q 0.1f   

// 定义一个结构体来模拟简单的对象上下文（可选，为了保持整洁）
typedef struct {
    int fd;
    char port_name[64];
    int is_open;
} SerialPort;

// 单个维度的卡尔曼状态
typedef struct {
    float estimate;  // 当前的最优估计值
    float error_cov; // 误差协方差 (表示我们多大程度上不确定当前的估计)
} Kalman1D;

// 每个标签包含 X 和 Y 两个维度的滤波器
typedef struct {
    Kalman1D kx;         // X轴滤波
    Kalman1D ky;         // Y轴滤波
    uint8_t initialized; // 标记该标签是否是第一次出现
} TagFilter;

int pg0403_serial_run();

#endif