#ifndef MQTT_INIT_H__
#define MQTT_INIT_H__
#include <time.h>
#include "mosquitto.h"
#include "cjson/cJSON.h"

//extern ThreadPool *pool;

#define MAX_SERVERS 15

#define MAX_RECONNECT_ATTEMPTS 10 

typedef struct {
    struct mosquitto *mosq;
    char host[128];
    int port;
    char client_id[64];
    int reconnect_attempts; // 新增：重连尝试次数
    bool permanently_failed; // 新增：标记是否永久失败
} mqttclient;

extern mqttclient g_clients_t[MAX_SERVERS];

#define BROKER_PORT 1883
#define USERNAME "admin"    // 替换为你的用户名
#define PASSWORD "admin"       // 替换为你的密码
extern struct mosquitto *mosq;//创建客服端


extern int gPwmCount;  // 计数
extern int gmessage_type;//message消息值

int mqtt_init();//mqtt初始化
//void on_connect(struct mosquitto *mosq, void *obj, int rc);//回调函数
//void on_message(struct mosquitto *mosq, void *obj, const struct mosquitto_message *message);//消息回调函数

int mqtt_cycle();//循环

//mqtt清理
void mqtt_clean();

//莫一个服务器连接失败发送
void send_fail_mqtt_conect();
#endif