#include "common.h"
#include "zlog.h"
#include "mylog.h"

const char *c_config_content = "[global]\n"
                             "strict init = true\n"
                             "buffer min = 1024\n"
                             "buffer max = 2MB\n"
                             "default format = \"%d(%Y-%m-%d %H:%M:%S.%ms) %-6V (%c:%F:%L) - %m%n\"\n"
                             "file perms = 600              # 设置文件权限\n"
                             "\n"
                             "[formats]\n"
                             "millisecond = \"%d(%Y-%m-%d %H:%M:%S.%ms) [%V] %m%n\"\n"
                             "\n"
                             "[rules]\n"
                             "# 日志文件路径，30天轮询，自动创建目录\n"
                             "my_log.*    \"/home/orangepi/car/master/log/log.log\", 30D; millisecond\n";
                             

//最后一行也可以写成"my_log.*    \"/home/orangepi/car/master/log/log.log\",100M; millisecond{rotate 5}\n";

#define LOG_FILE  "/home/orangepi/car/master/log/log.log" //日志文件

#define MAX_SIZE_MB 100  // 最大文件大小（MB）

static zlog_category_t *s_zlog_c = NULL;

int logprject_Init();
int logconf_create();
void check_and_delete_log();

int mylog_init(){
    if(logconf_create() != 0) {
        my_zlog_fatal( "日志创建失败");
        return 1;
    }

    check_and_delete_log();

    if(logprject_Init() != 0) {
        my_zlog_fatal( "日志初始化失败");
        return 2;
    }

    my_zlog_info("LOG_FILE权限成功");

    my_zlog_info("日志初始化成功");
    return 0;
}

/*创建log需要的config文件*/
int logconf_create() {
    const char *config_file = "/home/orangepi/car/master/zlog.conf";
    // 检查文件是否存在
    if (access(config_file, F_OK) != 0) {
        // 文件不存在，创建并写入内容
        FILE *fp = fopen(config_file, "w");
        if (fp == NULL) {
            perror("Failed to create zlog.conf");
            return 1;
        }
        // 写入配置内容
        fwrite(c_config_content, strlen(c_config_content), 1, fp);
        fclose(fp);

        int res=system("sudo chmod +666 /home/orangepi/car/master/zlog.conf");

        if(res==0) printf("zlog.conf has been created.\n");

    } else {
        printf("zlog.conf already exists.\n");
    }
    return 0;
}

/*检查并创建日志目录*/
static int create_log_dir_if_not_exist(const char *path) {
    char dir_path[256] = {0};
    const char *p = path;
    char *q = dir_path;
    
    // 提取目录部分
    while (*p != '\0') {
        *q = *p;
        if (*p == '/' && *(p+1) != '\0') {
            // 检查并创建每一级目录
            if (access(dir_path, F_OK) != 0) {
                if (mkdir(dir_path, 0755) != 0) {
                    fprintf(stderr, "Failed to create directory: %s\n", dir_path);
                    return -1;
                }
            }
        }
        p++;
        q++;
    }
    
    return 0;
}

/*初始化log*/
int logprject_Init() {
    int rc;
    zlog_category_t *c;
    if(create_log_dir_if_not_exist(LOG_FILE)!=0) {
        fprintf(stderr, "Failed to create log directory\n");
        return -1;
    }

     // 初始化 zlog
    rc = zlog_init("/home/orangepi/car/master/zlog.conf");
    if (rc) {
        fprintf(stderr, "zlog init failed\n");
        return -2;
    }
    
    // 获取日志分类
    s_zlog_c = zlog_get_category("my_log");
    if (!s_zlog_c) {
        fprintf(stderr, "get category failed\n");
        zlog_fini();
        return -3;
    }
    int res = system("sudo chmod +666 /home/orangepi/car/master/log/log.log");
    
    if(res != 0) printf("logprject_Init fail");

    return 0;
}

//日志文件过大则重新删除
void check_and_delete_log() {
    struct stat st;

    // 获取文件状态
    if (stat(LOG_FILE, &st) != 0) {
        perror("stat");
        return;
    }

    // 判断文件大小是否大于 MAX_SIZE_MB
    double size_mb = st.st_size / (1024.0 * 1024.0);
    if (size_mb > MAX_SIZE_MB) {
        printf("日志文件大小 %.2f MB 超过 %d MB，删除中...\n", size_mb, MAX_SIZE_MB);
        if (remove(LOG_FILE) != 0) {
            perror("删除文件失败");
        } else {
            printf("日志文件已删除。\n");
            int res=system("sudo reboot");//重启香橙派
            if(res==0) printf("重启。\n");
        }
    } else {
        printf("日志文件大小 %.2f MB，未超过 %d MB，无需删除。\n", size_mb, MAX_SIZE_MB);
    }
}

// 封装 zlog_debug
void my_zlog_debug(const char *format, ...) {
    if (s_zlog_c) {
        va_list args;
        va_start(args, format);
        vzlog_debug(s_zlog_c, format, args);
        va_end(args);
    }
}

// 封装 zlog_info
void my_zlog_info(const char *format, ...) {
    if (s_zlog_c) {
        va_list args;
        va_start(args, format);
        vzlog_info(s_zlog_c, format, args);
        va_end(args);
    }
}

// 封装 zlog_notice
void my_zlog_notice(const char *format, ...) {
    if (s_zlog_c) {
        va_list args;
        va_start(args, format);
        vzlog_notice(s_zlog_c, format, args);
        va_end(args);
    }
}

// 封装 zlog_warn
void my_zlog_warn(const char *format, ...) {
    if (s_zlog_c) {
        va_list args;
        va_start(args, format);
        vzlog_warn(s_zlog_c, format, args);
        va_end(args);
    }
}

// 封装 zlog_error
void my_zlog_error(const char *format, ...) {
    if (s_zlog_c) {
        va_list args;
        va_start(args, format);
        vzlog_error(s_zlog_c, format, args);
        va_end(args);
    }
}

// 封装 zlog_fatal
void my_zlog_fatal(const char *format, ...) {
    if (s_zlog_c) {
        va_list args;
        va_start(args, format);
        vzlog_fatal(s_zlog_c, format, args);
        va_end(args);
    }
}

// 结束 zlog
void my_log_close() {
    if (s_zlog_c) {
        zlog_fini();
        s_zlog_c = NULL;
    }
}
