#ifndef MAIN_H__
#define MAIN_H__

#include "common.h"
#include "app_device_common.h"
#include "drivers_common.h"
#include "modules_common.h"
#include "pthread_open.h"

/*设备id读取初始化*/
int device_id_file_init();

/*初始化log日志*/
int mylog_init();

/*wiringPi初始化函数*/
int  wiringPiSetup(); 

/*audio_config初始化*/
int audio_config_init();

/*音频初始化函数*/
int audio_init();

int hardware_iic_init();

/*mqtt的topic初始化*/
int device_mqtt_topic_init();

/*设备射击冷却初始化*/
int device_shot_cooling_init();

/*线程初始化函数*/
int thread_start_init(ThreadFunc thread_exit_time, ThreadFunc thread_mqtt_beat,
                 ThreadFunc thread_open_browser, ThreadFunc thread_mqtt_reconnect,
                 ThreadFunc thread_time_calculation, ThreadFunc thread_play_mp3);

/*像服务器请求*/
int request_date();

/*mqtt服务器和视频流地址初始化*/
int http_mqtt_video_init();

/*线程关闭函数*/
void thread_end_close() ;

/*相关设备线程等关闭函数*/
void device_end_close(int device_id);

void self_control_thread_close();//销毁自控的线程

/*关闭log日志记录*/
void my_log_close();

/*关闭硬件iic*/
int hardware_iic_close();

#endif
