#ifndef MAIN_H__
#define MAIN_H__

#include "common.h"
#include "app_device_common.h"
#include "drivers_common.h"
#include "modules_common.h"
#include "pthread_open.h"

/*设备id读取初始化*/
int device_id_file_init();

/*初始化log日志*/
int mylog_init();

/*wiringPi初始化函数*/
int  wiringPiSetup(); 

/*音频初始化函数*/
int audio_init();

int softiic_init();

/*mqtt的topic初始化*/
int device_mqtt_topic_init();

int ina225_init();

/*设备射击冷却初始化*/
int device_shot_cooling_init();

/*线程初始化函数*/
int thread_start_init(ThreadFunc thread_exit_time, ThreadFunc thread_mqtt_beat,
                 ThreadFunc thread_open_browser, ThreadFunc thread_mqtt_reconnect,
                 ThreadFunc thread_time_calculation, ThreadFunc thread_play_mp3);

/*像服务器请求*/
int request_date();

/*mqtt服务器和视频流地址初始化*/
int http_mqtt_video_init();

/*线程关闭函数*/
void thread_end_close() ;

/*相关设备线程等关闭函数*/
void device_end_close(int device_id);

/*关闭log日志记录*/
void my_log_close();

#endif
