#include "common.h"
#include "modules_common.h"
#include "ship0301_control.h"
#include "gpio_common.h"

void ship0301_stop() {
    pwmWrite(PWM_PIN_SPEED,75);
    pwmWrite(PWM_PIN_CHANGE,75);
}

void ship0301_mode_lift_flont(unsigned char gval) {
	int b=0;
   if (gval < 50) {
		pwmWrite(PWM_PIN_SPEED, 75);
	}
	else if (gval <= 60) {
		pwmWrite(PWM_PIN_SPEED, 79+b);
	}else if (gval <= 70) {
		pwmWrite(PWM_PIN_SPEED, 80+b);
	}else if(gval >70){
		int flont_speed = 80+(gval-70)/10+b;
		if(flont_speed>95) flont_speed = 95;
		pwmWrite(PWM_PIN_SPEED, flont_speed);
	}
}

void ship0301_mode_lift_back(unsigned char gval) {
	int b=0;
	if (gval < 50) {
		pwmWrite(PWM_PIN_SPEED, 75);
	} else if (gval <= 60) {
		pwmWrite(PWM_PIN_SPEED, 71-b);
	}else if (gval <= 70) {
		pwmWrite(PWM_PIN_SPEED, 70-b);
	} else if(gval >70){
		int back_speed = 70 - (gval-70)/10-b;
		if(back_speed<55) back_speed =55;
		pwmWrite(PWM_PIN_SPEED, back_speed);
	}  
}

void ship0301_mode_right_back(unsigned char gval) {
	int b=0;
   if (gval < 50) {
		pwmWrite(PWM_PIN_CHANGE, 75);
	}else if (gval <= 60) {
		pwmWrite(PWM_PIN_CHANGE, 79+b);
	}else if (gval <= 70) {
		pwmWrite(PWM_PIN_CHANGE, 80+b);
	}else if(gval >70){
		int flont_speed = 80+(gval-70)/10+b;
		if(flont_speed>95) flont_speed = 95;
		pwmWrite(PWM_PIN_CHANGE, flont_speed);
	}
}

void ship0301_mode_right_flont(unsigned char gval) {
	int b=0;
	if (gval < 50) {
		pwmWrite(PWM_PIN_CHANGE, 75);
	}else if (gval <= 60) {
		pwmWrite(PWM_PIN_CHANGE, 71-b);
	} else if (gval <= 70) {
		pwmWrite(PWM_PIN_CHANGE, 70-b);
	} else if(gval >70){
		int back_speed = 70 - (gval-70)/10-b;
		if(back_speed<55) back_speed =55;
		pwmWrite(PWM_PIN_CHANGE, back_speed);
	}
}

int ship0301_change_grading(int mode){
		int mode_val=0;
		switch(mode){
			case 2:
				mode_val=10;
				break;
			case 3:
				mode_val=20;
				break;
			case 4:
				mode_val=30;
				break;
			case 5:
				mode_val=50;
				break;
			default:
				break;
		}
		return mode_val;
}


void  ship0301_change(unsigned char *buf) {
   unsigned char type = buf[0];
    unsigned char mode = buf[1];
    unsigned char val = buf[2];

	static int ship0301_steering_t=0;
	static int ship0301_front_t =0;

	static int ship0301_front_val=0;
	static int ship0301_steering_val=0;
	
	int ship0301_count=40;

	if(type != 1) ship0301_count=ship0301_change_grading(type);

	if((mode == 1 ||mode == 2)&&val == 0) ship0301_front_t =0;
	if((mode == 3 ||mode == 4)&&val == 0) ship0301_steering_t=0;

	if(mode == 1&&val != 0) {
		ship0301_front_val=val;
		ship0301_front_t =1;
	}else if(mode == 2&&val != 0) {
		ship0301_front_t =2;
		ship0301_front_val=val;
	}

	if(mode == 3&&val != 0) {
		ship0301_steering_t =1;
		ship0301_steering_val = val;
	}else if(mode == 4&&val != 0) {
		ship0301_steering_t =2;
		ship0301_steering_val = val;
	}

	if(ship0301_front_t ==0&&ship0301_steering_t==0){
		ship0301_mode_lift_flont(0);
        ship0301_mode_right_flont(0);
	}else if(ship0301_front_t ==1&&ship0301_steering_t==0){
		ship0301_mode_lift_flont(ship0301_front_val);
        ship0301_mode_right_flont(ship0301_front_val);
	}else if(ship0301_front_t ==2&&ship0301_steering_t==0){
		ship0301_mode_lift_back(ship0301_front_val);
        ship0301_mode_right_back(ship0301_front_val);
	}else if(ship0301_front_t ==0&&ship0301_steering_t==1){
		ship0301_mode_right_flont(ship0301_steering_val+ship0301_count);
		ship0301_mode_lift_flont(0);
	}else if(ship0301_front_t ==0&&ship0301_steering_t==2){
		ship0301_mode_right_flont(0);
		ship0301_mode_lift_flont(ship0301_steering_val+ship0301_count+10);
	}else if(ship0301_front_t ==1&&ship0301_steering_t==1){
		ship0301_mode_right_flont(ship0301_steering_val+ship0301_count+10);
		ship0301_mode_lift_flont(ship0301_count+15);
	}else if(ship0301_front_t ==1&&ship0301_steering_t==2){
		ship0301_mode_right_flont(ship0301_count+15);
		ship0301_mode_lift_flont(ship0301_steering_val+ship0301_count+10);
	}else if(ship0301_front_t ==2&&ship0301_steering_t==1){
		ship0301_mode_lift_back(ship0301_count+15);
        ship0301_mode_right_back(ship0301_steering_val+ship0301_count+10);
	}else if(ship0301_front_t ==2&&ship0301_steering_t==2){
		ship0301_mode_lift_back(ship0301_steering_val+ship0301_count+10);
        ship0301_mode_right_back(ship0301_count+15);
	}




    
}