#ifndef MQTT_INIT_H__
#define MQTT_INIT_H__
#include <time.h>
#include "mosquitto.h"
#include "cjson/cJSON.h"

//extern ThreadPool *pool;

/*2为泰国1为国内，3为中东*/
#define MQTT_IPMODE 1 // 或通过编译选项 -DMODE=1 指定

#if MQTT_IPMODE == 1
    #define BROKER_ADDRESS "119.45.167.177"
#elif MQTT_IPMODE == 2
    #define BROKER_ADDRESS "mqtt.luckycar.top"
#elif MQTT_IPMODE == 3    
    #define BROKER_ADDRESS   "47.91.125.224"
#else
    #define BROKER_ADDRESS "127.0.0.1"  // 默认地址

#endif

//#define BROKER_ADDRESS "119.45.167.177"
#define BROKER_PORT 1883
#define USERNAME "admin"    // 替换为你的用户名
#define PASSWORD "admin"       // 替换为你的密码
extern struct mosquitto *mosq;//创建客服端
extern int gPwmCount;  // 计数
extern int gmessage_type;//message消息值

int mqtt_init();//mqtt初始化
int mqtt_create(struct mosquitto *mosq);//创建mqtt客服端
void on_connect(struct mosquitto *mosq, void *obj, int rc);//回调函数
void on_message(struct mosquitto *mosq, void *obj, const struct mosquitto_message *message);//消息回调函数
int mqtt_cycle(struct mosquitto *mosq);//循环
void mqtt_clean(struct mosquitto *mosq);//清理

#endif